/*
 * CS 3114 Project 4
 * Author: Kevin Lee
 * Compiler: Eclipse 3.7.0
 * Operating System: Windows 7 x64
 * Date Completed: 12/4/2011
 * 
 * The following program is an combination of the previous three
 * projects. This program implements the GIS b-tree and
 * quad-tree, but instead of keeping the PRQuad-Tree in memory,
 * the PRQuad-Tree interfaces with a memory manager to store and
 * retrieve internal and leaf nodes, as well as city names. The
 * memory manager interfaces to a file ("p4bin.dat") using a 
 * buffer pool. The buffer pool is implemented using a least 
 * recently used block list. 
 * 
 * Note that while the PRQuad-Tree is optimized for speed, the
 * conversion of CityRecords to handles for the b-tree severely
 * slows down the program (see test _seq-16384-IR). If the b-tree
 * is kept completely in memory, the program runs >30x faster.
 * 
 * On my honor:
 *
 * - I have not used source code obtained from another student,
 * or any other unauthorized source, either modified or
 * unmodified.
 *
 * - All source code and documentation used in my program is
 * either my original work, or was derived by me from the
 * source code published in the textbook for this course.
 *
 * - I have not discussed coding details about this project with
 * anyone other than my partner (in the case of a joint
 * submission), instructor, ACM/UPE tutors or the TAs assigned
 * to this course. I understand that I may discuss the concepts
 * of this program with other students, and that another student
 * may help me debug my program so long as neither of us writes
 * anything during the discussion or modifies any computer file
 * during the discussion. I have violated neither the spirit nor
 * letter of this restriction.
 */

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class Bindisk {

	public static void main(String[] args) {

		// 3 arguments must be supplied to the program
		if (args.length != 3) {
			System.out.println("3 Arguments must be supplied!");
			return;
		}

		// Parses passed arguments into member variables
		String dataFile = args[0];
		int buffSize = Integer.parseInt(args[1]);
		int blockSize = Integer.parseInt(args[2]);

		if (buffSize < 1 || buffSize > 20) {
			System.out.println("Number of buffers must be between 1 and 20");
			return;
		}
		
		LRUBuffer buffer = new LRUBuffer("p4bin.dat", "p4bin-stat.dat", buffSize, blockSize);
		MemManager memManager = new MemManager(buffer, blockSize);
		
		// Check to make sure the command file exists
		File cmdFile = new File(dataFile);
		if (!cmdFile.exists()) {
			System.out.printf("Command file not found");
			return;
		}
		
		CmdParser GISParser = new CmdParser(memManager);
		long time1 = System.currentTimeMillis();
		// Parse each command with the memory client
		try {
			BufferedReader reader = new BufferedReader(new FileReader(cmdFile));
			String cin;
			while ((cin = reader.readLine()) != null) {
				cin = cin.trim();
				if (cin.length() != 0) {
					// Send string to command parser
					GISParser.Parse(cin);
				}
			}
		} catch (FileNotFoundException e) {
			System.out.printf("Command file not found");
			return;
		} catch (IOException e) {
			System.out.printf("Unable to read input file");
			return;
		}
		
		buffer.flushBuffer();
		long time2 = System.currentTimeMillis();
		buffer.writeStats(time2-time1);
	}

}
